
# Table of Contents

1.  [Purpose](#org42e0afd)
2.  [Installation](#org3f8d4b6)
    1.  [Installation from CTAN](#org9d14a52)
    2.  [Installation from the SVN report](#org215c06a)
3.  [Project page & bug reports](#org11eab36)
4.  [Request for help](#orga576a2a)
5.  [License](#org708a5d6)



<a id="org42e0afd"></a>

# Purpose

The purpose of the `makegobbler` package is to make easy to gobble (drop) or ungobble
(keep) some part of your LaTeX source code, conditionally or unconditionally. The part
that is to be gobbled/ungobbled is delimited with a user-defined delimiter control
sequence.


<a id="org3f8d4b6"></a>

# Installation

Below `TEXMF_INSTALL_DIR` environment variable points at the TEXMF directory desired for installation.


<a id="org9d14a52"></a>

## Installation from CTAN

One can use the following bash script to get and install the package
from CTAN, you will need tools like `wget`, `latexmk`, `perl` (to run
`latexmk`) and a LaTeX distro :

    # make a temp dir for easier cleanup
    work_dir=$(mktemp -d /tmp/makegobbler-install.XXXXXX)
    pushd $work_dir
    # get the paquetage
    wget https://mirror.ctan.org/macros/latex/contrib/makegobbler.zip
    # unzip
    unzip makegobbler.zip
    cd makegobbler
    # set TEXMF_INSTALL_DIR to the installation target TEXMF
    [ -d "$TEXMF_INSTALL_DIR" ] || TEXMF_INSTALL_DIR=$(HOME)/texmf
    pdftex makegobbler.ins
    mkdir -p "$TEXMF_INSTALL_DIR/tex/latex/makegobbler"
    cp makegobbler.sty "$TEXMF_INSTALL_DIR/tex/latex/makegobbler"
    # doc generation, skip if you don't want to recompile the manual
    latexmk -pdf makegobbler.dtx
    mkdir -p "$TEXMF_INSTALL_DIR/doc/latex/makegobbler"
    cp makegobbler.pdf "$TEXMF_INSTALL_DIR/doc/latex/makegobbler/makegobbler-doc.pdf"
    # cleanup
    popd
    rm -fr $work_dir


<a id="org215c06a"></a>

## Installation from the SVN report

If you wish the very latest dev version possibly not yet released to
CTAN &#x2014; at your own perils &#x2014; then you may use the following
script. You will need a `svn` client, as well as GNU make.

    # make a temp dir for easier cleanup
    work_dir=$(mktemp -d /tmp/makegobbler-install.XXXXXX)
    pushd $work_dir
    # get the package source
    svn checkout https://svn.gnu.org.ua/sources/latex-makegobbler/trunk .
    # set TEXMF_INSTALL_DIR to the installation target TEXMF
    [ -d "$TEXMF_INSTALL_DIR" ] || TEXMF_INSTALL_DIR=$(HOME)/texmf
    export TEXMF_INSTALL_DIR
    # make is GNUmake
    make install README_EXT=org
    # cleanup
    popd
    rm -fr $work_dir


<a id="org11eab36"></a>

# Project page & bug reports

-   Project page : <https://puszcza.gnu.org.ua/projects/latex-makegobbler>
-   Please submit bug reports here : <https://puszcza.gnu.org.ua/bugs/?group=latex-makegobbler>


<a id="orga576a2a"></a>

# Request for help

Any volunteer to translate the manual to your favorite language is welcome.


<a id="org708a5d6"></a>

# License

Le package is dual licensed.

-   [LPPL 1.3c license](https://ctan.org/license/lppl1.3c)
-   [CeCILL v2 license](https://cecill.info/licences/Licence_CeCILL_V2-fr.html)

