/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.channeling;

import choco.IPretty;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class DomainChanneling
extends AbstractLargeIntSConstraint {
    private final int dsize;
    private final IStateInt oldinf;
    private final IStateInt oldsup;

    public DomainChanneling(IntDomainVar[] yij, IntDomainVar xi, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, ArrayUtils.append(yij, {xi}));
        this.dsize = yij.length;
        this.oldinf = environment.makeInt();
        this.oldsup = environment.makeInt();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.dsize ? 8 : 15;
    }

    @Override
    public void awake() throws ContradictionException {
        ((IntDomainVar[])this.vars)[this.dsize].updateInf(0, this, false);
        ((IntDomainVar[])this.vars)[this.dsize].updateSup(this.dsize - 1, this, false);
        super.awake();
        this.oldinf.set(((IntDomainVar[])this.vars)[this.dsize].getInf());
        this.oldsup.set(((IntDomainVar[])this.vars)[this.dsize].getSup());
    }

    @Override
    public void propagate() throws ContradictionException {
        int left;
        int right = left = Integer.MIN_VALUE;
        for (int i = 0; i < this.dsize; ++i) {
            if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(0)) {
                if (i == right + 1) {
                    right = i;
                    continue;
                }
                ((IntDomainVar[])this.vars)[this.dsize].removeInterval(left, right, this, false);
                left = i;
                right = i;
                continue;
            }
            if (((IntDomainVar[])this.vars)[i].isInstantiatedTo(1)) {
                ((IntDomainVar[])this.vars)[this.dsize].instantiate(i, this, false);
                this.clearBooleanExcept(i);
                continue;
            }
            if (((IntDomainVar[])this.vars)[this.dsize].canBeInstantiatedTo(i)) continue;
            this.clearBoolean(i);
        }
        ((IntDomainVar[])this.vars)[this.dsize].removeInterval(left, right, this, false);
        if (((IntDomainVar[])this.vars)[this.dsize].isInstantiated()) {
            int value = ((IntDomainVar[])this.vars)[this.dsize].getVal();
            this.clearBooleanExcept(value);
            ((IntDomainVar[])this.vars)[value].instantiate(1, this, false);
        }
    }

    @Override
    public void awakeOnInf(int i) throws ContradictionException {
        this.clearBoolean(this.oldinf.get(), ((IntDomainVar[])this.vars)[i].getInf());
        this.oldinf.set(((IntDomainVar[])this.vars)[i].getInf());
    }

    @Override
    public void awakeOnSup(int i) throws ContradictionException {
        this.clearBoolean(((IntDomainVar[])this.vars)[i].getSup() + 1, this.oldsup.get() + 1);
        this.oldsup.set(((IntDomainVar[])this.vars)[i].getSup());
    }

    private void clearBoolean(int val) throws ContradictionException {
        ((IntDomainVar[])this.vars)[val].instantiate(0, this, false);
    }

    private void clearBoolean(int begin, int end) throws ContradictionException {
        for (int i = begin; i < end; ++i) {
            this.clearBoolean(i);
        }
    }

    private void clearBooleanExcept(int val) throws ContradictionException {
        this.clearBoolean(this.oldinf.get(), val);
        this.clearBoolean(val + 1, this.oldsup.get());
    }

    @Override
    public final void awakeOnRem(int idx, int val) throws ContradictionException {
        this.clearBoolean(val);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getVal();
        if (idx == this.dsize) {
            ((IntDomainVar[])this.vars)[val].instantiate(1, this, false);
            this.clearBooleanExcept(val);
        } else if (val == 1) {
            ((IntDomainVar[])this.vars)[this.dsize].instantiate(idx, this, false);
            this.clearBooleanExcept(idx);
        } else {
            ((IntDomainVar[])this.vars)[this.dsize].removeVal(idx, this, false);
            if (((IntDomainVar[])this.vars)[this.dsize].isInstantiated()) {
                ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars)[this.dsize].getVal()].instantiate(1, this, false);
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int val = tuple[tuple.length - 1];
        for (int i = 0; i < tuple.length - 1; ++i) {
            if (i != val && tuple[i] != 0) {
                return false;
            }
            if (i != val || tuple[i] == 1) continue;
            return false;
        }
        return val >= 0 && val <= tuple.length - 1;
    }

    @Override
    public String pretty() {
        StringBuilder b = new StringBuilder();
        b.append("DomainChanneling ").append(((IntDomainVar[])this.vars)[this.dsize].pretty()).append(" <=> ");
        b.append(StringUtils.pretty((IPretty[])this.vars, 0, this.dsize));
        return b.toString();
    }
}

