% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive-trawl.R
\name{pkgstats_from_archive}
\alias{pkgstats_from_archive}
\title{Trawl a local CRAN archive and extract statistics from all packages}
\usage{
pkgstats_from_archive(
  path,
  archive = TRUE,
  prev_results = NULL,
  results_file = NULL,
  chunk_size = 1000L,
  save_full = FALSE,
  results_path = tempdir()
)
}
\arguments{
\item{path}{Path to local CRAN archive}

\item{archive}{If \code{TRUE}, extract statistics for all packages in the
\verb{/Archive} sub-directory, otherwise only statistics for main \code{tarballs}
directory (that is, current packages only).}

\item{prev_results}{Result of previous call to this function, if available.
Submitting previous results will ensure that only newer packages not present
in previous result will be analysed, with new results simply appended to
previous results. This parameter can also specify a file to be read with
\code{readRDS()}.}

\item{results_file}{Can be used to specify the name or full path of a \code{.Rds}
file to which results should be saved once they have been generated. The
'.Rds' extension will be automatically appended, and any other extensions
will be ignored.}

\item{chunk_size}{Divide large archive trawl into chunks of this size, and
save intermediate results to local files. These intermediate files can be
combined to generate a single \code{prev_results} file, to enable jobs to be
stopped and re-started without having to recalculate all results. These files
will be named \code{pkgstats-results-N.Rds}, where "N" incrementally numbers each
file.}

\item{save_full}{If \code{TRUE}, full \link{pkgstats} results are saved for each
package to files in \code{results_path}.}

\item{results_path}{Path to save intermediate files generated by the
\code{chunk_size} parameter described above.}
}
\value{
A \code{data.frame} object with one row for each package containing
summary statistics generated from the \link{pkgstats_summary} function.
}
\description{
Trawl a local CRAN archive and extract statistics from all packages
}
\note{
Each analysis in an archive trawl spawns several \emph{unsupervised}
processes, preventing the trawl from running in parallel. Accurate results
can only be guaranteed by running this function as a single process.
}
\concept{archive}
