## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)


## ----setup--------------------------------------------------------------------
library(blockr.core)


## ----empty-board, eval = FALSE------------------------------------------------
# serve(
#   new_board()
# )


## ----empty-board-shinylive_url, echo = FALSE, results = 'asis'----------------
# extract the code from knitr code chunks by ID
code <- paste0(
  c(
    "webr::install(\"blockr.core\", repos = \"https://cynkra.github.io/blockr.webR/\")", #nolint
    "webr::install(\"blockr.dplyr\", repos = \"https://cynkra.github.io/blockr.webR/\")",
    "library(blockr.core)",
    "library(blockr.dplyr)",
    "library(bsicons)",
    knitr::knit_code$get("empty-board")
  ),
  collapse = "\n"
)

empty_board_url <- roxy.shinylive::create_shinylive_url(code, header = FALSE)
cat(sprintf("[Open in Shinylive](%s)\n\n", empty_board_url))


## ----empty-board-demo, echo = FALSE, out.width = '150%', out.extra = 'style = "position: relative; z-index:1"', eval = knitr::is_html_output()----
knitr::include_url(empty_board_url, height = "800px")


## flowchart TD
##   subgraph board[Board]
## 
##     subgraph stack1[Stack 1]
##       direction TB
##       import[Data 1]
##       transform[Transform]
##       visualize[Visualize]
##       import2[Data 2]
##       merge[Merge data]
##       transform2[Subset columns]
##       import --> transform --> |filter| merge --> |left join| visualize
##       import2 --> transform2 --> |subset| merge
##     end
## 
##     subgraph stack2[Stack 2]
##       direction TB
##       import3[Data 3]
##       llm[Transform LLM]
##       visualise_llm[Visualize LLM]
##       import3 --> llm --> visualise_llm
##     end
##   end

## ----eval = FALSE-------------------------------------------------------------
# serve(new_dataset_block("iris"))


## ----eval = FALSE-------------------------------------------------------------
# serve(
#   new_merge_block(by = "name"),
#   data = list(x = datasets::BOD, y = datasets::ChickWeight)
# )


## ----eval = FALSE-------------------------------------------------------------
# serve(new_board())


## ----simple-board, eval = FALSE-----------------------------------------------
# serve(
#   new_board(
#     blocks = c(
#       a = new_dataset_block("BOD"),
#       b = new_dataset_block("ChickWeight"),
#       c = new_merge_block("Time")
#     ),
#     links = c(
#       ac = new_link("a", "c", "x"),
#       bc = new_link("b", "c", "y")
#     ),
#     stacks = list(ac = c("a", "c"))
#   )
# )


## ----shinylive_url, echo = FALSE, results = 'asis'----------------------------
# extract the code from knitr code chunks by ID
code <- paste0(
  c(
    "webr::install(\"blockr.core\", repos = \"https://cynkra.github.io/blockr.webR/\")", #nolint
    "library(blockr.core)",
    "library(bsicons)",
    knitr::knit_code$get("simple-board")
  ),
  collapse = "\n"
)

url <- roxy.shinylive::create_shinylive_url(code, header = FALSE)
cat(sprintf("[Open in Shinylive](%s)\n\n", url))


## ----shinylive_iframe, echo = FALSE, out.width = '150%', out.extra = 'style = "position: relative; z-index:1"', eval = knitr::is_html_output()----
knitr::include_url(url, height = "800px")

