# GACE 1.0.0

* Provides deterministic forecasting for weekly, monthly, quarterly, and yearly
  time series using the Generalized Adaptive Capped Estimator.

* Includes a structured preprocessing pipeline with support for handling of
  non-positive or missing values, optional interpolation, and optional
  winsorization of extreme observations.

* Implements multiple growth components including year-over-year, short-term
  movement, rolling-window behavior, and long-run drift.

* Growth components are combined using a trimmed, robust averaging framework to
  ensure stable signal extraction across different series types.

* Includes volatility-aware asymmetric caps that adapt to series characteristics
  and frequency.

* Provides optional seasonal scaling using smoothed, normalized seasonal factors
  derived from the historical pattern.

* Forecast generation uses a recursive formulation incorporating growth
  moderation (gamma) and level–growth blending (beta).

* Includes a user-facing forecasting interface (gace_forecast) that returns
  forecasts in a consistent structure.

* Includes a plotting helper (plot_gace) for visualizing historical and
  projected values using ggplot2.

* Package includes documentation, examples, a vignette, and tests, and is
  structured for CRAN compatibility.