/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import choco.kernel.common.util.iterators.DisposableIntIterator;

public class IntList {
    protected final int[] content;
    protected int size;
    protected int currentIdx;
    private IntListIterator _iterator;

    public IntList(int size) {
        this.size = size;
        this.content = new int[size];
    }

    public IntList(int[] content, int size) {
        this.content = content;
        this.size = size;
    }

    public IntList copy() {
        int[] copContent = new int[this.content.length];
        System.arraycopy(this.content, 0, copContent, 0, copContent.length);
        return new IntList(copContent, this.size);
    }

    public int getFirst() {
        if (this.size > 0) {
            return this.content[0];
        }
        throw new IllegalArgumentException("List is empty");
    }

    public int getSize() {
        return this.size;
    }

    public void reInit() {
        this.size = 0;
    }

    public void add(int v) {
        if (this.size == this.content.length) {
            throw new IllegalArgumentException(String.valueOf(this.size));
        }
        this.content[this.size++] = v;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(16);
        b.append('{');
        DisposableIntIterator iter = this.iterator();
        if (iter.hasNext()) {
            b.append(iter.next());
            while (iter.hasNext()) {
                b.append(',').append(iter.next());
            }
        }
        iter.dispose();
        b.append('}');
        return new String(b);
    }

    public final DisposableIntIterator iterator() {
        if (this._iterator == null || !this._iterator.reusable()) {
            this._iterator = new IntListIterator();
        }
        this._iterator.init(this);
        return this._iterator;
    }

    protected static class IntListIterator
    extends DisposableIntIterator {
        int currentIdx;
        IntList list;

        protected IntListIterator() {
        }

        public void init(IntList list) {
            super.init();
            this.list = list;
            this.currentIdx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIdx < this.list.size;
        }

        @Override
        public int next() {
            return this.list.content[this.currentIdx++];
        }

        @Override
        public void remove() {
            if (this.currentIdx != this.list.size) {
                --this.currentIdx;
                this.list.content[this.currentIdx] = this.list.content[this.list.size - 1];
            }
            --this.list.size;
        }

        public int read() {
            return this.list.content[this.currentIdx];
        }
    }
}

