/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import jdplus.toolkit.base.api.data.Seq;
import lombok.Generated;

public final class InternalSeq {
    public static <E> void forEach(Seq<E> seq, Consumer<? super E> action) {
        for (int i = 0; i < seq.length(); ++i) {
            action.accept(seq.get(i));
        }
    }

    public static <E> E[] toArray(Seq<E> seq, IntFunction<E[]> generator) {
        E[] result = generator.apply(seq.length());
        for (int i = 0; i < result.length; ++i) {
            result[i] = seq.get(i);
        }
        return result;
    }

    public static <E> List<E> toList(Seq<E> seq) {
        ArrayList<E> result = new ArrayList<E>(seq.length());
        for (int i = 0; i < seq.length(); ++i) {
            result.add(seq.get(i));
        }
        return result;
    }

    public static <E> int firstIndexOf(Seq<E> seq, Predicate<? super E> predicate) {
        for (int i = 0; i < seq.length(); ++i) {
            if (!predicate.test(seq.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Generated
    private InternalSeq() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class SequenceIterator<E>
    implements Iterator<E> {
        private final Seq<E> seq;
        private int cur = 0;

        @Override
        public boolean hasNext() {
            return this.cur < this.seq.length();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.seq.get(this.cur++);
            }
            throw new NoSuchElementException();
        }

        @Generated
        public SequenceIterator(Seq<E> seq) {
            this.seq = seq;
        }
    }
}

