/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information.formatters;

import java.text.NumberFormat;
import java.util.Locale;
import jdplus.toolkit.base.api.information.formatters.InformationFormatter;
import jdplus.toolkit.base.api.information.formatters.StringFormatter;
import jdplus.toolkit.base.api.timeseries.regression.RegressionItem;

public final class RegressionItemFormatter
implements InformationFormatter {
    private final boolean showDesc_;

    public RegressionItemFormatter() {
        this.showDesc_ = false;
    }

    public RegressionItemFormatter(boolean showdesc) {
        this.showDesc_ = showdesc;
    }

    @Override
    public int getDefaultRepresentationLength() {
        return 3;
    }

    @Override
    public String format(Object obj, int item, Locale locale) {
        RegressionItem reg = (RegressionItem)obj;
        if (item == 0) {
            return this.format(reg, locale);
        }
        if (reg.getDescription() == null || !this.showDesc_) {
            ++item;
        }
        switch (Math.abs(item)) {
            case 1: {
                return StringFormatter.cleanup(reg.getDescription());
            }
            case 2: {
                return InformationFormatter.format6(locale, reg.getCoefficient());
            }
            case 3: {
                if (reg.getStdError() == 0.0) {
                    return null;
                }
                return InformationFormatter.format4(locale, reg.getCoefficient() / reg.getStdError());
            }
            case 4: {
                return InformationFormatter.format4(locale, reg.getPvalue());
            }
        }
        return null;
    }

    private String format(RegressionItem reg, Locale locale) {
        StringBuilder builder = new StringBuilder();
        if (reg.getDescription() != null) {
            builder.append(reg.getDescription()).append(':');
        }
        NumberFormat df4 = InformationFormatter.df4(locale);
        builder.append(df4.format(reg.getCoefficient()));
        if (reg.getStdError() != 0.0) {
            builder.append('[').append(df4.format(reg.getCoefficient() / reg.getStdError())).append(']');
        }
        return builder.toString();
    }
}

