/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.ckms;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.ckms.CkmsFilter;
import jdplus.toolkit.base.core.ssf.ckms.CkmsState;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DiffuseSquareRootInitializer;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;

public class CkmsDiffuseInitializer
implements CkmsFilter.IFastFilterInitializer {
    private final OrdinaryFilter.Initializer initializer;

    public CkmsDiffuseInitializer() {
        this.initializer = null;
    }

    public CkmsDiffuseInitializer(OrdinaryFilter.Initializer initializer) {
        this.initializer = initializer;
    }

    @Override
    public int initializeFilter(CkmsState fstate, UpdateInformation upd, ISsf ssf, ISsfData data) {
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        State state = new State(dim);
        int t = 0;
        if (this.initializer != null ? (t = this.initializer.initializeFilter(state, ssf, data)) < 0 : (t = new DiffuseSquareRootInitializer().initializeFilter(state, ssf, data)) < 0) {
            return -1;
        }
        fstate.a().copy(state.a());
        ISsfDynamics dynamics = ssf.dynamics();
        ISsfLoading loading = ssf.loading();
        ISsfError error = ssf.measurementError();
        FastMatrix P = state.P();
        DataBlock k = upd.M();
        double f = loading.ZVZ(0, P);
        if (error != null) {
            f += error.at(0);
        }
        upd.setVariance(f);
        loading.ZM(0, P, k);
        DataBlock l = fstate.l();
        l.copy(k);
        dynamics.TX(0, l);
        FastMatrix TVT = P.deepClone();
        dynamics.TVT(0, TVT);
        dynamics.addV(0, TVT);
        TVT.sub(P);
        TVT.addXaXt(-1.0 / f, l);
        TVT.mul(-f);
        int imax = 0;
        double lmax = TVT.get(0, 0);
        for (int i = 1; i < dim; ++i) {
            double lcur = TVT.get(i, i);
            if (!(lcur > lmax)) continue;
            imax = i;
            lmax = lcur;
        }
        if (lmax > 0.0) {
            l.copy(TVT.column(imax));
            l.mul(Math.sqrt(1.0 / lmax));
        } else {
            if (!TVT.isZero(1.0E-6)) {
                throw new SsfException("Invalid fast filter");
            }
            l.set(0.0);
        }
        return t;
    }
}

