/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class OrdinaryFilter {
    private final Initializer initializer;
    private State state;
    private UpdateInformation updinfo;
    private ISsfLoading loading;
    private ISsfError error;
    private ISsfDynamics dynamics;
    private boolean missing;

    public OrdinaryFilter(Initializer initializer) {
        this.initializer = initializer;
    }

    public OrdinaryFilter() {
        this.initializer = null;
    }

    protected boolean error(int t, ISsfData data) {
        this.missing = data.isMissing(t);
        if (this.missing) {
            this.updinfo.setMissing();
            return false;
        }
        DataBlock M = this.updinfo.M();
        this.loading.ZM(t, this.state.P(), M);
        double v = this.loading.ZX(t, M);
        if (v < 1.0E-9) {
            v = 0.0;
        }
        if (this.error != null) {
            v += this.error.at(t);
        }
        this.updinfo.setVariance(v);
        double y = data.get(t);
        double e = y - this.loading.ZX(t, this.state.a());
        if (v == 0.0) {
            if (Math.abs(e) < 1.0E-9) {
                e = 0.0;
            } else {
                throw new SsfException("Inconsistent constraints in the model");
            }
        }
        this.updinfo.set(e, data.isConstraint(t));
        return true;
    }

    public State getFinalState() {
        return this.state;
    }

    private int initialize(ISsf ssf, ISsfData data) {
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.updinfo = new UpdateInformation(ssf.getStateDim());
        if (this.initializer == null) {
            this.state = State.of(ssf);
            return this.state == null ? -1 : 0;
        }
        this.state = new State(ssf.getStateDim());
        return this.initializer.initializeFilter(this.state, ssf, data);
    }

    public boolean process(ISsf ssf, ISsfData data, IFilteringResults rslts) {
        int t = this.initialize(ssf, data);
        if (t < 0) {
            return false;
        }
        int end = data.length();
        while (t < end) {
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Forecast);
            }
            if (this.error(t, data)) {
                if (rslts != null) {
                    rslts.save(t, this.updinfo);
                }
                this.state.update(this.updinfo);
            } else if (rslts != null) {
                rslts.save(t, this.updinfo);
            }
            if (rslts != null) {
                rslts.save(t, this.state, StateInfo.Concurrent);
            }
            this.state.next(t++, this.dynamics);
        }
        return true;
    }

    public static interface Initializer {
        public int initializeFilter(State var1, ISsf var2, ISsfData var3);
    }
}

