/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jdplus.toolkit.base.api.processing.ProcessingLog;

public class DefaultProcessingLog
implements ProcessingLog {
    private static final String[] EMPTY = new String[0];
    private final List<ProcessingLog.Information> logs = new ArrayList<ProcessingLog.Information>();
    private final LinkedList<String> context = new LinkedList();
    private boolean verbose = true;
    private static final String SEP = " > ";

    private String context() {
        StringBuilder builder = new StringBuilder();
        if (!this.context.isEmpty()) {
            builder.append(this.context.get(0));
            for (int i = 1; i < this.context.size(); ++i) {
                builder.append(SEP).append(this.context.get(i));
            }
        }
        return builder.toString();
    }

    @Override
    public void push(String routine) {
        this.context.addLast(routine);
    }

    @Override
    public void pop() {
        this.context.removeLast();
    }

    @Override
    public List<ProcessingLog.Information> all() {
        return Collections.unmodifiableList(this.logs);
    }

    public String[] getMessages(ProcessingLog.InformationType type) {
        if (this.logs.isEmpty()) {
            return EMPTY;
        }
        return (String[])this.logs.stream().filter(inf -> inf.getType() == type).toArray(String[]::new);
    }

    public String[] getErrorMessages() {
        return this.getMessages(ProcessingLog.InformationType.Error);
    }

    public String[] getWarningMessages() {
        return this.getMessages(ProcessingLog.InformationType.Warning);
    }

    public String[] getRemarkMessages() {
        return this.getMessages(ProcessingLog.InformationType.Remark);
    }

    public boolean hasInformation(ProcessingLog.InformationType type) {
        return this.logs.stream().anyMatch(log -> log.getType() == type);
    }

    public boolean hasErrors() {
        return this.hasInformation(ProcessingLog.InformationType.Error);
    }

    public boolean hasWarnings() {
        return this.hasInformation(ProcessingLog.InformationType.Warning);
    }

    public boolean hasRemarks() {
        return this.hasInformation(ProcessingLog.InformationType.Remark);
    }

    @Override
    public void error(Exception err) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, err != null ? err.getMessage() : "Unexpected error", ProcessingLog.InformationType.Error, err));
    }

    @Override
    public void error(String msg, Object err) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Error, err));
    }

    @Override
    public void error(String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Error, null));
    }

    @Override
    public void error(String origin, Exception err) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, err.getMessage(), ProcessingLog.InformationType.Error, err));
    }

    @Override
    public void error(String origin, String msg, Object err) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Error, err));
    }

    @Override
    public void warning(String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Warning, info));
    }

    @Override
    public void warning(String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Warning, null));
    }

    @Override
    public void warning(String origin, String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Warning, info));
    }

    @Override
    public void warning(String origin, String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Warning, null));
    }

    @Override
    public void remark(String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Remark, info));
    }

    @Override
    public void remark(String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Remark, null));
    }

    @Override
    public void remark(String origin, String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Remark, info));
    }

    @Override
    public void remark(String origin, String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Remark, null));
    }

    @Override
    public void info(String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Info, null));
    }

    @Override
    public void info(String msg, Object details) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Info, details));
    }

    @Override
    public void info(String origin, String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Info, info));
    }

    @Override
    public void info(String origin, String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), origin, msg, ProcessingLog.InformationType.Info, null));
    }

    @Override
    public void step(String msg) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Step, null));
    }

    @Override
    public void step(String msg, Object info) {
        this.logs.add(new ProcessingLog.Information(this.context(), null, msg, ProcessingLog.InformationType.Step, info));
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

