/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.math;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.splines.CubicSpline;
import lombok.Generated;

public final class CubicSplines {
    public static double[] monotonic(double[] x, double[] y, double[] pos) {
        DoubleUnaryOperator fn = CubicSpline.monotonic((double[])x, (double[])y);
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = fn.applyAsDouble(pos[i]);
        }
        return pos;
    }

    public static double[] natural(double[] x, double[] y, double[] pos) {
        DoubleUnaryOperator fn = CubicSpline.of((double[])x, (double[])y);
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = fn.applyAsDouble(pos[i]);
        }
        return pos;
    }

    public static double[] periodic(double[] x, double[] y, double[] pos) {
        DoubleUnaryOperator fn = CubicSpline.periodic((double[])x, (double[])y);
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = fn.applyAsDouble(pos[i]);
        }
        return pos;
    }

    public static Matrix periodicCardinalSplines(double[] x, double[] pos) {
        int dim = x.length;
        int n = pos.length;
        FastMatrix splines = FastMatrix.make((int)n, (int)(dim - 1));
        DataBlockIterator cols = splines.columnsIterator();
        int i = 0;
        while (cols.hasNext()) {
            double[] f = new double[dim];
            if (i == 0) {
                f[0] = 1.0;
                f[dim - 1] = 1.0;
            } else {
                f[i] = 1.0;
            }
            DoubleUnaryOperator fn = CubicSpline.periodic((double[])x, (double[])f);
            cols.next().set(j -> fn.applyAsDouble(pos[j]));
            ++i;
        }
        return splines;
    }

    @Generated
    private CubicSplines() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

