/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.Gauss;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.ssf.arima.ExactArimaForecasts;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimators;

public class BurmanEstimatesC {
    private static final double[] ONE = new double[]{1.0};
    private final int nfcasts;
    private final int nbcasts;
    private final DoubleSeq data;
    private final UcarimaModel ucm;
    private final boolean bmean;
    private final int mcmp;
    private final double ser;
    private final WienerKolmogorovEstimators wk;
    private double[] ar;
    private double[] ma;
    private double[][] g;
    private double[] z;
    private DoubleSeq[] estimates;
    private DoubleSeq[] forecasts;
    private DoubleSeq[] backcasts;
    private DoubleSeq xbcasts;
    private DoubleSeq xfcasts;
    private LUDecomposition lu;
    private int nf;
    private double mean;
    private double meanc;

    public static Builder builder() {
        return new Builder();
    }

    private BurmanEstimatesC(Builder builder) {
        this.data = builder.data;
        this.bmean = builder.bmean;
        this.mcmp = builder.mcmp;
        this.ucm = builder.ucm;
        this.ser = builder.ser;
        this.nfcasts = builder.nf;
        this.nbcasts = builder.nb;
        this.wk = new WienerKolmogorovEstimators(this.ucm);
        this.initModel();
        this.extendSeries();
        for (int i = 0; i < this.ucm.getComponentsCount(); ++i) {
            this.calc(i);
        }
    }

    private void calc(int cmp) {
        int k;
        double s;
        int i2;
        int i3;
        int n = this.data.length();
        if (cmp == this.mcmp && this.isTrendConstant()) {
            double c = this.meanc;
            this.estimates[cmp] = DoubleSeq.onMapping((int)n, i -> c);
            this.forecasts[cmp] = DoubleSeq.onMapping((int)this.nfcasts, i -> c);
            this.backcasts[cmp] = DoubleSeq.onMapping((int)this.nbcasts, i -> c);
        } else if (this.g[cmp] == null) {
            return;
        }
        int qstar = this.ma.length - 1;
        int pstar = this.ar.length - 1;
        if (this.useD1()) {
            ++qstar;
        }
        int rstar = qstar + pstar;
        double[] gcur = this.g[cmp];
        int gstar = gcur.length - 1;
        double[] w1 = new double[n + 2 * this.nf];
        int start = this.nf - 2 * qstar;
        int end = this.nf + n + qstar;
        for (int i4 = start; i4 < end; ++i4) {
            double s2 = gcur[0] * this.z[i4];
            for (int k2 = 1; k2 <= gstar; ++k2) {
                s2 += gcur[k2] * this.z[i4 + k2];
            }
            w1[i4] = s2;
        }
        double[] ww = new double[rstar];
        int i5 = 0;
        int j = this.nf + n + qstar - pstar;
        while (i5 < pstar) {
            ww[i5] = w1[j];
            ++i5;
            ++j;
        }
        this.lu.solve(DataBlock.of((double[])ww));
        double[] x1 = new double[n + 2 * this.nf];
        start = this.nf + n + qstar - pstar;
        int i6 = 0;
        int j2 = start;
        while (i6 < rstar) {
            x1[j2] = ww[i6];
            ++i6;
            ++j2;
        }
        end = this.nf - 2 * qstar;
        for (i6 = start - 1; i6 >= end; --i6) {
            double s3 = w1[i6];
            for (int k3 = 1; k3 < this.ma.length; ++k3) {
                s3 -= x1[i6 + k3] * this.ma[k3];
            }
            x1[i6] = s3 / this.ma[0];
        }
        double[] w2 = new double[n + 2 * this.nf];
        start = this.nf - qstar;
        end = this.nf + n + 2 * qstar;
        for (i3 = start; i3 < end; ++i3) {
            double s4 = gcur[0] * this.z[i3];
            for (int k4 = 1; k4 <= gstar; ++k4) {
                s4 += gcur[k4] * this.z[i3 - k4];
            }
            w2[i3] = s4;
        }
        ww = new double[rstar];
        int j3 = this.nf + pstar - qstar;
        for (i3 = 0; i3 < pstar; ++i3) {
            ww[i3] = w2[--j3];
        }
        this.lu.solve(DataBlock.of((double[])ww));
        double[] x2 = new double[n + 2 * this.nf];
        start = this.nf + pstar - qstar;
        int j4 = start;
        for (i2 = 0; i2 < ww.length; ++i2) {
            x2[--j4] = ww[i2];
        }
        end = this.nf + n + 2 * qstar;
        for (i2 = start; i2 < end; ++i2) {
            double s5 = w2[i2];
            for (int k5 = 1; k5 < this.ma.length; ++k5) {
                s5 -= x2[i2 - k5] * this.ma[k5];
            }
            x2[i2] = s5 / this.ma[0];
        }
        int nfc = Math.max(2 * qstar, this.nfcasts);
        int nbc = Math.max(2 * qstar, this.nbcasts);
        double[] rslt = new double[n + nfc + nbc];
        int xstart = this.nf - 2 * qstar;
        int xend = this.nf + n + 2 * qstar;
        int del = nbc - this.nf;
        int i7 = xstart;
        int j5 = xstart + del;
        while (i7 < xend) {
            rslt[j5] = x1[i7] + x2[i7];
            ++i7;
            ++j5;
        }
        this.estimates[cmp] = DoubleSeq.of((double[])rslt, (int)nbc, (int)n);
        double[] car = this.ucm.getComponent(cmp).getAr().asPolynomial().toArray();
        for (j5 = nbc - 2 * qstar - 1; j5 >= 0; --j5) {
            s = 0.0;
            for (k = 1; k < car.length; ++k) {
                s -= car[k] * rslt[j5 + k];
            }
            rslt[j5] = s;
        }
        for (j5 = nbc + n + 2 * qstar; j5 < rslt.length; ++j5) {
            s = 0.0;
            for (k = 1; k < car.length; ++k) {
                s -= car[k] * rslt[j5 - k];
            }
            rslt[j5] = s;
        }
        if (cmp == this.mcmp && this.useMean()) {
            int i8 = 0;
            while (i8 < rslt.length) {
                int n2 = i8++;
                rslt[n2] = rslt[n2] + this.meanc;
            }
        }
        if (this.nfcasts > 0) {
            this.forecasts[cmp] = DoubleSeq.of((double[])rslt, (int)(n + nbc), (int)this.nfcasts);
        }
        if (this.nbcasts > 0) {
            this.backcasts[cmp] = DoubleSeq.of((double[])rslt, (int)(nbc - this.nbcasts), (int)this.nbcasts);
        }
    }

    public DoubleSeq estimates(int cmp, boolean signal) {
        if (signal) {
            return this.estimates[cmp];
        }
        return this.data.fastOp(this.estimates[cmp], (a, b) -> a - b);
    }

    private void extendSeries() {
        int q = this.ma.length - 1;
        int p = this.ar.length - 1;
        this.nf = q > p ? 2 * q : p + q;
        ExactArimaForecasts fcasts = new ExactArimaForecasts();
        fcasts.prepare(this.wk.getUcarimaModel().getModel(), this.bmean);
        this.xfcasts = fcasts.forecasts(this.data, Math.max(this.nf, this.nfcasts));
        this.xbcasts = fcasts.backcasts(this.data, Math.max(this.nf, this.nbcasts));
        this.mean = this.bmean ? fcasts.getMean() : 0.0;
        int n = this.data.length();
        this.z = new double[n + 2 * this.nf];
        this.data.copyTo(this.z, this.nf);
        this.xfcasts.range(0, this.nf).copyTo(this.z, this.nf + n);
        this.xbcasts.drop(this.xbcasts.length() - this.nf, 0).copyTo(this.z, 0);
        if (this.useMean()) {
            this.meanc = this.correctedMean();
            int i = 0;
            while (i < this.z.length) {
                int n2 = i++;
                this.z[n2] = this.z[n2] - this.meanc;
            }
        }
    }

    private IArimaModel model() {
        return this.wk.getUcarimaModel().getModel();
    }

    private double correctedMean() {
        IArimaModel arima = this.model();
        return this.mean / arima.getStationaryAr().asPolynomial().evaluateAt(1.0);
    }

    public DoubleSeq forecasts(int cmp, boolean signal) {
        if (signal) {
            return this.forecasts[cmp];
        }
        DoubleSeq xf = this.xfcasts.range(0, this.nfcasts);
        return this.forecasts[cmp].fastOp(xf, (a, b) -> a - b);
    }

    public DoubleSeq backcasts(int cmp, boolean signal) {
        if (signal) {
            return this.backcasts[cmp];
        }
        int nb = this.xbcasts.length();
        DoubleSeq xb = this.xbcasts.range(nb - this.nbcasts, nb);
        return this.backcasts[cmp].fastOp(xb, (a, b) -> a - b);
    }

    public DoubleSeq getSeriesBackcasts() {
        return this.xbcasts.drop(this.xbcasts.length() - this.nbcasts, 0);
    }

    public DoubleSeq getSeriesForecasts() {
        return this.xfcasts.range(0, this.nfcasts);
    }

    public UcarimaModel getUcarimaModel() {
        return this.wk.getUcarimaModel();
    }

    private void initModel() {
        IArimaModel model = this.ucm.getModel();
        int ncmps = this.ucm.getComponentsCount();
        this.estimates = new DoubleSeq[ncmps];
        this.forecasts = new DoubleSeq[ncmps];
        this.backcasts = new DoubleSeq[ncmps];
        this.g = new double[ncmps][];
        Polynomial pma = model.getMa().asPolynomial();
        double v = model.getInnovationVariance();
        if (v != 1.0) {
            pma = pma.times(Math.sqrt(v));
        }
        Polynomial par = model.getAr().asPolynomial();
        for (int i = 0; i < ncmps; ++i) {
            ArimaModel cmp = this.ucm.getComponent(i);
            if (cmp.isNull()) continue;
            if (!cmp.isNull()) {
                BackFilter scar;
                SymmetricFilter sma = cmp.symmetricMa();
                BackFilter umar = model.getNonStationaryAr();
                BackFilter ucar = cmp.getNonStationaryAr();
                BackFilter nar = umar.divide(ucar);
                BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
                BackFilter smar = model.getStationaryAr();
                if (smp.simplify(smar, scar = cmp.getStationaryAr())) {
                    smar = (BackFilter)smp.getLeft();
                    scar = (BackFilter)smp.getRight();
                }
                BackFilter dar = scar;
                nar = nar.times(smar);
                BackFilter denom = new BackFilter(pma).times(dar);
                SymmetricFilter c = sma.times(SymmetricFilter.convolutionOf((IFiniteFilter)nar));
                double mvar = model.getInnovationVariance();
                if (mvar != 1.0) {
                    c = c.times(1.0 / mvar);
                }
                BackFilter gf = c.decompose(denom);
                this.g[i] = gf.asPolynomial().toArray();
                continue;
            }
            this.g[i] = ONE;
        }
        if (this.useD1()) {
            par = par.times(UnitRoots.D1);
        }
        this.ma = pma.toArray();
        this.ar = par.toArray();
        this.initSolver();
    }

    private boolean useD1() {
        return this.bmean && this.model().getNonStationaryArOrder() > 0;
    }

    private boolean useMean() {
        return this.bmean && this.model().getNonStationaryArOrder() == 0;
    }

    private boolean isTrendConstant() {
        return this.wk.getUcarimaModel().getComponent(this.mcmp).isNull();
    }

    private void initSolver() {
        int qstar = this.ma.length - 1;
        int pstar = this.ar.length - 1;
        FastMatrix M = FastMatrix.square((int)(pstar + qstar));
        MatrixWindow top = M.top(0);
        FastMatrix M1 = top.vnext(pstar);
        for (int j = 0; j <= qstar; ++j) {
            M1.subDiagonal(j).set(this.ma[j]);
        }
        FastMatrix M2 = top.vnext(qstar);
        for (int j = 0; j <= pstar; ++j) {
            M2.subDiagonal(j).set(this.ar[pstar - j]);
        }
        this.lu = Gauss.decompose((FastMatrix)M);
    }

    public boolean isMeanCorrection() {
        return this.bmean;
    }

    public DoubleSeq stdevEstimates(int cmp) {
        if (this.wk.getUcarimaModel().getComponent(cmp).isNull()) {
            return Doubles.EMPTY;
        }
        try {
            int n = (this.data.length() + 1) / 2;
            double[] err = this.wk.totalErrorVariance(cmp, true, 0, n);
            double[] e = new double[this.data.length()];
            for (int i = 0; i < err.length; ++i) {
                double x;
                e[i] = x = this.ser * Math.sqrt(err[i]);
                e[e.length - i - 1] = x;
            }
            return DoubleSeq.of((double[])e);
        }
        catch (ArimaException | MatrixException err) {
            return Doubles.EMPTY;
        }
    }

    public DoubleSeq stdevForecasts(int cmp, boolean signal) {
        try {
            if (this.wk.getUcarimaModel().getComponent(cmp).isNull() || this.nfcasts == 0) {
                return Doubles.EMPTY;
            }
            double[] e = this.wk.totalErrorVariance(cmp, signal, -this.nfcasts, this.nfcasts);
            double[] err = new double[this.nfcasts];
            for (int i = 0; i < this.nfcasts; ++i) {
                err[i] = this.ser * Math.sqrt(e[this.nfcasts - 1 - i]);
            }
            return DoubleSeq.of((double[])err);
        }
        catch (ArimaException | MatrixException err) {
            return null;
        }
    }

    public DoubleSeq stdevBackcasts(int cmp, boolean signal) {
        if (this.wk.getUcarimaModel().getComponent(cmp).isNull() || this.nbcasts == 0) {
            return null;
        }
        try {
            double[] e = this.wk.totalErrorVariance(cmp, signal, -this.nbcasts, this.nbcasts);
            double[] err = new double[this.nbcasts];
            for (int j = this.nbcasts - 1; j >= 0; --j) {
                err[j] = this.ser * Math.sqrt(e[j]);
            }
            return DoubleSeq.of((double[])err);
        }
        catch (ArimaException | MatrixException err) {
            return null;
        }
    }

    public static class Builder {
        private int nf;
        private int nb;
        private DoubleSeq data;
        private UcarimaModel ucm;
        private boolean bmean;
        private int mcmp;
        private double ser = 1.0;

        public Builder forecastsCount(int nf) {
            this.nf = nf;
            return this;
        }

        public Builder backcastsCount(int nb) {
            this.nb = nb;
            return this;
        }

        public Builder data(DoubleSeq y) {
            this.data = y;
            return this;
        }

        public Builder mean(boolean mean) {
            this.bmean = mean;
            return this;
        }

        public Builder meanComponent(int cmp) {
            this.mcmp = cmp;
            return this;
        }

        public Builder innovationStdev(double ser) {
            this.ser = ser;
            return this;
        }

        public Builder ucarimaModel(UcarimaModel ucm) {
            this.ucm = ucm;
            return this;
        }

        public BurmanEstimatesC build() {
            return new BurmanEstimatesC(this);
        }
    }
}

